﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Text;

namespace WpfApp1.Common
{
    public class ViewModelBase : INotifyPropertyChanged
    {
        // 实现接口的事件
        public event PropertyChangedEventHandler? PropertyChanged;

        // 封装触发事件的方法，供子类调用
        protected void OnPropertyChanged([CallerMemberName] string? propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        // 示例属性：修改时触发通知
        private string _value;
        public string Value
        {
            get => _value;
            set
            {
                if (_value != value)
                {
                    _value = value;
                    OnPropertyChanged(); // [CallerMemberName]会自动传入"Value"
                }
            }
        }
    }
}
