﻿using CommunityToolkit.Mvvm.ComponentModel;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.CompilerServices;
using System.Text;

namespace WpfApp1.Model
{

    // 改写后：使用 ObservableObject（框架内置）+ [ObservableProperty]，消除所有手搓的 INotifyPropertyChanged 样板代码
    public partial class TodoItem : ObservableObject
    {
        // 框架自动生成：私有字段 _content + 公共属性 Content + PropertyChanged 通知
        [ObservableProperty]
        private string _content = string.Empty;

        // 框架自动生成：私有字段 _isCompleted + 公共属性 IsCompleted + PropertyChanged 通知
        [ObservableProperty]
        private bool _isCompleted;
    }

    /* 
     * 下面是手搓代码
    // 待办项实体，实现INotifyPropertyChanged（状态变更通知界面）
    public class TodoItem : INotifyPropertyChanged
    {
        private string _content;
        private bool _isCompleted;

        public string Content
        {
            get => _content;
            set { _content = value; OnPropertyChanged(); }
        }

        public bool IsCompleted
        {
            get => _isCompleted;
            set { _isCompleted = value; OnPropertyChanged(); }
        }

        public event PropertyChangedEventHandler? PropertyChanged;
        protected void OnPropertyChanged([CallerMemberName] string? propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
    */
}
